/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.panels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.ui.panels.AbstractPanel;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.RefreshEnergyEffect;

public class EnergyPanel
extends AbstractPanel {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Energy Panel Tip");
    public static final String[] MSG = EnergyPanel.tutorialStrings.TEXT;
    public static final String[] LABEL = EnergyPanel.tutorialStrings.LABEL;
    private static final int RAW_W = 256;
    private static final int ORB_W = 128;
    private static final Color ENERGY_TEXT_COLOR = new Color(1.0f, 1.0f, 0.86f, 1.0f);
    public static float fontScale = 1.0f;
    public static final float FONT_POP_SCALE = 2.0f;
    private static final float ORB_IMG_SCALE = 1.15f * Settings.scale;
    public static int totalCount = 0;
    private Hitbox tipHitbox = new Hitbox(0.0f, 0.0f, 120.0f * Settings.scale, 120.0f * Settings.scale);
    private Texture gainEnergyImg;
    private float energyVfxAngle = 0.0f;
    private float energyVfxScale = Settings.scale;
    private Color energyVfxColor = Color.WHITE.cpy();
    public static float energyVfxTimer = 0.0f;
    public static final float ENERGY_VFX_TIME = 2.0f;
    private static final float VFX_ROTATE_SPEED = -30.0f;
    private float angle5;
    private float angle4;
    private float angle3;
    private float angle2;
    private float angle1;

    public EnergyPanel() {
        super(198.0f * Settings.scale, 190.0f * Settings.scale, -480.0f * Settings.scale, 200.0f * Settings.scale, 12.0f * Settings.scale, -12.0f * Settings.scale, null, true);
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.gainEnergyImg = ImageMaster.loadImage("images/ui/topPanel/energyRedVFX.png");
                break;
            }
            case THE_SILENT: {
                this.gainEnergyImg = ImageMaster.loadImage("images/ui/topPanel/energyGreenVFX.png");
                break;
            }
            case CROWBOT: {
                this.gainEnergyImg = ImageMaster.loadImage("images/ui/topPanel/energyGreenVFX.png");
                break;
            }
        }
    }

    public static void setEnergy(int energy) {
        totalCount = energy;
        AbstractDungeon.effectsQueue.add(new RefreshEnergyEffect());
        energyVfxTimer = 2.0f;
        fontScale = 2.0f;
    }

    public static void addEnergy(int e) {
        if ((totalCount += e) >= 9) {
            UnlockTracker.unlockAchievement("ADRENALINE");
        }
        AbstractDungeon.effectsQueue.add(new RefreshEnergyEffect());
        fontScale = 2.0f;
        energyVfxTimer = 2.0f;
    }

    public static void useEnergy(int e) {
        totalCount -= e;
        if (e != 0) {
            fontScale = 2.0f;
        }
    }

    public void update() {
        this.updateRed();
        this.updateVfx();
        if (fontScale != 1.0f) {
            fontScale = MathHelper.scaleLerpSnap(fontScale, 1.0f);
        }
        this.tipHitbox.update();
        if (this.tipHitbox.hovered && !AbstractDungeon.isScreenUp) {
            AbstractDungeon.overlayMenu.hoveredTip = true;
        }
        if (Settings.isDebug) {
            if (InputHelper.scrolledDown && totalCount != 10) {
                EnergyPanel.addEnergy(1);
            } else if (InputHelper.scrolledUp && totalCount != 0) {
                EnergyPanel.useEnergy(1);
            }
        }
    }

    private void updateRed() {
        if (totalCount == 0) {
            this.angle5 += Gdx.graphics.getDeltaTime() * -5.0f;
            this.angle4 += Gdx.graphics.getDeltaTime() * 5.0f;
            this.angle3 += Gdx.graphics.getDeltaTime() * -8.0f;
            this.angle2 += Gdx.graphics.getDeltaTime() * 8.0f;
            this.angle1 += Gdx.graphics.getDeltaTime() * 72.0f;
        } else {
            this.angle5 += Gdx.graphics.getDeltaTime() * -20.0f;
            this.angle4 += Gdx.graphics.getDeltaTime() * 20.0f;
            this.angle3 += Gdx.graphics.getDeltaTime() * -40.0f;
            this.angle2 += Gdx.graphics.getDeltaTime() * 40.0f;
            this.angle1 += Gdx.graphics.getDeltaTime() * 360.0f;
        }
    }

    private void updateVfx() {
        if (energyVfxTimer != 0.0f) {
            this.energyVfxColor.a = Interpolation.exp10In.apply(0.5f, 0.0f, 1.0f - energyVfxTimer / 2.0f);
            this.energyVfxAngle += Gdx.graphics.getDeltaTime() * -30.0f;
            this.energyVfxScale = Settings.scale * Interpolation.exp10In.apply(1.0f, 0.1f, 1.0f - energyVfxTimer / 2.0f);
            if ((energyVfxTimer -= Gdx.graphics.getDeltaTime()) < 0.0f) {
                energyVfxTimer = 0.0f;
                this.energyVfxColor.a = 0.0f;
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        if (!Settings.hideLowerElements) {
            this.tipHitbox.move(this.current_x, this.current_y);
            this.renderOrb(sb);
            this.renderVfx(sb);
            String energyMsg = totalCount + "/" + AbstractDungeon.player.energy.energy;
            switch (AbstractDungeon.player.chosenClass) {
                case IRONCLAD: {
                    FontHelper.energyNumFontRed.getData().setScale(fontScale);
                    FontHelper.renderFontCentered(sb, FontHelper.energyNumFontRed, energyMsg, this.current_x, this.current_y, ENERGY_TEXT_COLOR);
                    break;
                }
                case THE_SILENT: {
                    FontHelper.energyNumFontGreen.getData().setScale(fontScale);
                    FontHelper.renderFontCentered(sb, FontHelper.energyNumFontGreen, energyMsg, this.current_x, this.current_y, ENERGY_TEXT_COLOR);
                    break;
                }
                case CROWBOT: {
                    FontHelper.energyNumFontGreen.getData().setScale(fontScale);
                    FontHelper.renderFontCentered(sb, FontHelper.energyNumFontGreen, energyMsg, this.current_x, this.current_y, ENERGY_TEXT_COLOR);
                    break;
                }
                default: {
                    FontHelper.energyNumFontRed.getData().setScale(fontScale);
                    FontHelper.renderFontCentered(sb, FontHelper.energyNumFontRed, energyMsg, this.current_x, this.current_y, ENERGY_TEXT_COLOR);
                }
            }
            this.tipHitbox.render(sb);
            if (Settings.COMMON_TIP && this.tipHitbox.hovered && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT && !AbstractDungeon.isScreenUp) {
                TipHelper.renderGenericTip(50.0f * Settings.scale, 380.0f * Settings.scale, LABEL[0], MSG[0]);
            }
        }
    }

    private void renderOrb(SpriteBatch sb) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                if (totalCount == 0) {
                    this.renderRedOrbDisabled(sb);
                    break;
                }
                this.renderRedOrb(sb);
                break;
            }
            case THE_SILENT: {
                if (totalCount == 0) {
                    this.renderGreenOrbDisabled(sb);
                    break;
                }
                this.renderGreenOrb(sb);
                break;
            }
            case CROWBOT: {
                if (totalCount == 0) {
                    this.renderGreenOrbDisabled(sb);
                    break;
                }
                this.renderGreenOrb(sb);
                break;
            }
        }
    }

    private void renderGreenOrb(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER2, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER3, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER4, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle3, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER5, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
        sb.setBlendFunction(770, 1);
        sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER1, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle4, 0, 0, 128, 128, false, false);
        sb.setBlendFunction(770, 771);
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER6, this.current_x - 128.0f, this.current_y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 256, 256, false, false);
    }

    private void renderGreenOrbDisabled(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER2D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle2, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER3D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER4D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle3, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER5D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER1D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle4, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_GREEN_LAYER6, this.current_x - 128.0f, this.current_y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 256, 256, false, false);
    }

    private void renderRedOrb(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.ENERGY_RED_LAYER1, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle1, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER2, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle2, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER3, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle3, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER4, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle4, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER5, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle5, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER6, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
    }

    private void renderRedOrbDisabled(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.ENERGY_RED_LAYER1D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle1, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER2D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle2, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER3D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle3, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER4D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle4, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER5D, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, this.angle5, 0, 0, 128, 128, false, false);
        sb.draw(ImageMaster.ENERGY_RED_LAYER6, this.current_x - 64.0f, this.current_y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, ORB_IMG_SCALE, ORB_IMG_SCALE, 0.0f, 0, 0, 128, 128, false, false);
    }

    private void renderVfx(SpriteBatch sb) {
        if (energyVfxTimer != 0.0f) {
            sb.setBlendFunction(770, 1);
            sb.setColor(this.energyVfxColor);
            sb.draw(this.gainEnergyImg, this.current_x - 128.0f, this.current_y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.energyVfxScale, this.energyVfxScale, -this.energyVfxAngle + 50.0f, 0, 0, 256, 256, true, false);
            sb.draw(this.gainEnergyImg, this.current_x - 128.0f, this.current_y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.energyVfxScale, this.energyVfxScale, this.energyVfxAngle, 0, 0, 256, 256, false, false);
            sb.setBlendFunction(770, 771);
        }
    }

    public static int getCurrentEnergy() {
        if (AbstractDungeon.player == null) {
            return 0;
        }
        return totalCount;
    }
}

